<script type="text/javascript">
    jQuery(document).ready(function($) {

        $('.dipi-tippy').each(function(i, item) {
            tippy(item, {
                content: item.getAttribute('data-tooltip'),
                placement: 'bottom',
                theme: 'dipi-light',
                animation: 'shift-toward'
            });
        })

         
        let DipiLayoutImporter = function() {
            <?php
            global $wp_filesystem;
            WP_Filesystem();
            if (!$wp_filesystem->exists(DIPI_LAYOUTS_LIST)) {
                return;
            }
            ?>
            this.steps = 1;
            this.layout_name = null;
            this.current_task = 0;
            this.errors = [];
            this.layouts = <?php echo $wp_filesystem->get_contents(DIPI_LAYOUTS_LIST) ?>;
            this.assets_url = '<?php echo plugin_dir_url(__FILE__); ?>';
            this.current_layout = null
            this.config = {};
            this.results = {};

        }

        DipiLayoutImporter.prototype.get_tasks = function() {
            let tasks = [
                'initialize',
                'download'
            ];
            let $tasks = $('#dipi-layout-importer-config input[name="dipi_layout_conten"]');
            $tasks.each(function() {
                if ($(this).is(':checked')) {
                    tasks.push($(this).val());
                }
            });
            this.tasks = tasks;
        }

        DipiLayoutImporter.prototype.init = function() {
            // $('#dipi-layout-start-import').on('click', this.start_import.bind(this));
            $('#dipi-layout-start-import').on('click', this.showPopup.bind(this));
            $('#dipi-confirmation-cancel').on('click', this.closePopup.bind(this));
            $('#dipi-confirmation-import').on('click', this.start_import.bind(this));

            $('body').on('click', '#dipi-layout-setup-layout', this.setup_layout.bind(this));
            $('.dipi-layout-select-layout').on('click', this.select_layout.bind(this));
            $('.dipi-layout-back').on('click', this.back_step.bind(this));
            $('body').on('click', '#dipi-layout-setup-layout-opener', this.open_setup_layout.bind(this));
            $('body').on('click', '#dipi-layout-setup-layout-back', this.reset_ui.bind(this));
        }
        DipiLayoutImporter.prototype.showPopup = function(e) {
            e.preventDefault();
            console.log(this.tasks)

            let tasks = [];
            let $tasks = $('#dipi-layout-importer-config input[name="dipi_layout_conten"]');
            $tasks.each(function() {
                if ($(this).is(':checked')) {
                    tasks.push($(this).val());
                }
            });
            
            
            let overrides_text = '<ul class="dipi-import-layout-settings">';
            let overrides = 0;
            const icon = `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-info"><circle cx="12" cy="12" r="10"></circle><path d="M12 16v-4"></path><path d="M12 8h.01"></path></svg>`;

            if (tasks.includes("widgets")) {
                overrides_text += `<li>${icon} Widgets</li>`;overrides++;
            }
            if (tasks.includes("customizer")) {
                overrides_text += `<li>${icon} Customizer</li>`;overrides++;
            }
            if (tasks.includes("divi-options")) {
                overrides_text += `<li>${icon} Divi Theme Options</li>`;overrides++;
            }
            if (tasks.includes("dipi-options")) {
                overrides_text += `<li>${icon} Divi Pixel Options</li>`;overrides++;
            }
            if (tasks.includes("builder-templates")) {
                overrides_text += `<li>${icon} Theme Builder Templates</li>`;overrides++;
            }
            overrides_text += `</ul>`;
            let html = `Import <span class="dipi-import-layout-name">${this.current_layout.name}</span> template.<br>`;
            if(overrides > 0){
                html += `This action will <b>override</b> the following settings:<br>${overrides_text}`;
            }
            
            $('#dipi-confirmation-popup .dipi-popup-content').html(html);
            $('#dipi-confirmation-popup').addClass('active');
            return false;
        }
        
        DipiLayoutImporter.prototype.closePopup = function(e) {
            e.preventDefault();
             $('#dipi-confirmation-popup').removeClass('active');
            return false;
        }
        

        DipiLayoutImporter.prototype.reset_ui = function(e) {
            $('div[class^="dipi-layout-box dipi-layout-importer-setp-"]').hide();
            this.steps = 0;
            this.next_step();
        }
        DipiLayoutImporter.prototype.open_setup_layout = function(e) {
            $('.dipi-layout-importer-setp-1').hide();
            this.setup_layout_ui();
        }
        DipiLayoutImporter.prototype.setup_layout = function(e) {
            e.preventDefault();
            $('#dipi-layout-setup-layout').addClass('loading').removeClass('done');
            let nonce = $('#dipi_layout_setup_nonce').val();
            let homepage = $('#dipi-layout-importer-setup select[name="dipi_layout_homepage"]').val();
            let menus = {};

            $('#dipi-layout-importer-setup select[name="dipi_layout_homepage"], .dipi-layout-menu').on('change', function() {
                $('#dipi-layout-setup-layout').removeClass('loading').removeClass('done');
            })
            $('.dipi-layout-menu').each(function() {
                menus[$(this).attr('name')] = $(this).val();
            });

            var cta_menus = $('input[name="cta_menu[]"]:checked').map(function() {
                return this.value;
            }).get();

            jQuery.post(
                ajaxurl, {
                    'action': 'dipi_layout_setup',
                    'menus': menus,
                    'homepage': homepage,
                    'cta_menus': cta_menus,
                    'dipi_layout_setup_nonce': nonce
                },
                (response) => {
                    $('#dipi-layout-setup-layout').addClass('done').removeClass('loading');
                },
                "json"
            );
            return false;
        }

        DipiLayoutImporter.prototype.setup_layout_ui = function() {
            if ($('#dipi-layout-list #dipi-layout-importer-setup').length) {
                $('#dipi-layout-list #dipi-layout-importer-setup').remove();
            }
            jQuery.post(
                ajaxurl, {
                    'action': 'dipi_setup_layout_ui'
                },
                (response) => {
                    $('#dipi-layout-list').append(response.content)
                },
                "json"
            );
        }

        DipiLayoutImporter.prototype.select_layout = function(e) {
            e.preventDefault();
            this.layout_name = $(e.target).next('input').val();
            this.current_layout = this.layouts[this.layout_name];
            this.package_name = this.current_layout['package_name'];
            $('.dipi-import-layout-name').html(this.current_layout.name);
            this.next_step();
            return false;
        }

        DipiLayoutImporter.prototype.start_import = function(e) {
            e.preventDefault();
            $('#dipi-confirmation-popup').removeClass('active');
            this.get_tasks();
            $('#dipi-layout-layout-name').html(this.current_layout.name)
            this.next_step();
            this.import();
            return false;
        }
        DipiLayoutImporter.prototype.done = function(showSetup) {
            if(this.errors.length) {
                $('#dipi-import-log').find('.dipi-layout-importer-task-done .dipi-layout-progress-icon img').attr('src', this.assets_url + '/warning.png').show()
                $('#dipi-import-log').find('.dipi-layout-importer-task-done .message').html("Done with Errors!");
            } else {
                $('#dipi-import-log').find('.dipi-layout-importer-task-done .dipi-layout-progress-icon img').attr('src', this.assets_url + '/check.png').show()
            }
            
            $('#dipi-import-log').find('.dipi-layout-importer-task-done').show();
            this.finalize();
           
            if(showSetup || typeof showSetup === 'undefined') {
                
                this.setup_layout_ui();
            }
        }
        DipiLayoutImporter.prototype.import = function() {
            if (typeof this.tasks[this.current_task] === 'undefined') {
                this.done();
                return;
            }
            $('#dipi-import-log .dipi-layout-importer-task-' + this.tasks[this.current_task]).show();
            jQuery.post(
                ajaxurl, {
                    'action': 'dipi_layout_import',
                    'layout_name': this.layout_name,
                    'task': this.tasks[this.current_task],
                    'package_name': this.package_name,
                    'dipi_layout_import_nonce': $('#dipi_layout_import_nonce').val()
                },
                (response) => {
                    if (response[this.tasks[this.current_task]]['success']) {
                        $('#dipi-import-log').find('.dipi-layout-importer-task-' + this.tasks[this.current_task] + ' .dipi-layout-progress-icon img').attr('src', this.assets_url + '/check.png')
                    } else {
                        this.errors.push(response[this.tasks[this.current_task]]['errorMessage']);
                        this.handelError();
                        return;
                    }

                    this.results[this.tasks[this.current_task]];
                    this.current_task = this.current_task + 1;
                  
                    this.import();
                    $('#dipi-layout-progress-value').css('width', (((parseInt(this.current_task)) / parseInt(this.tasks.length)) * 100) + '%');

                },
                "json"
            ).fail((response) => {
                this.handelError("fail");
            });
        }
        DipiLayoutImporter.prototype.handelError = function(errorSource) {

            $('#dipi-import-log').find('.dipi-layout-importer-task-' + this.tasks[this.current_task] + ' .dipi-layout-progress-icon img').attr('src', this.assets_url + '/error.png')
            if(errorSource === 'fail') {
                this.errors.push("Error executing task: " + this.tasks[this.current_task]) + " PLease contact support team.";
            }
            if(this.tasks[this.current_task] !== 'download' && this.tasks[this.current_task] !== 'initialize') {
                this.current_task = this.current_task + 1;
                this.import();
            }else {
                 
                $('#dipi-import-log').find('.dipi-layout-importer-task-done .dipi-layout-progress-icon img').attr('src', this.assets_url + '/error.png').show()
                $('#dipi-import-log').find('.dipi-layout-importer-task-done .message').html("Fail!");
                $('#dipi-import-log').find('.dipi-layout-importer-task-done').show();
            }
            this.displayErrors();
        }

        DipiLayoutImporter.prototype.displayErrors = function() {
            $errorList = $("#dipi-layout-importer-results .errors-list ul");
            this.errors.forEach((error) => {
                $errorList.append(`<li>${error}</li>`);
            });
        }

        DipiLayoutImporter.prototype.finalize = function(e) {
            jQuery.post(
                ajaxurl, {
                    'action': 'dipi_layout_finalize',
                    'layout_name': this.layout_name,
                    'dipi_layout_import_nonce': $('#dipi_layout_import_nonce').val()
                },
                (response) => {

                },
                "json"
            );
        }
        DipiLayoutImporter.prototype.back_step = function() {
            this.steps = this.steps - 1;
            $('.dipi-layout-importer-setp-' + (this.steps - 1)).hide().removeClass('active');
            $('.dipi-layout-importer-setp-' + this.steps).show().addClass('active');
        }
        DipiLayoutImporter.prototype.next_step = function() {
            this.steps = this.steps + 1;
            $('.dipi-layout-importer-setp-' + (this.steps - 1)).hide().removeClass('active');
            $('.dipi-layout-importer-setp-' + this.steps).show().addClass('active');
        }
        let DLI = new DipiLayoutImporter();
        DLI.init();
    });
</script>