<?php

if (!defined('ABSPATH')) {
	return;
}

class Dipi_Layout_Importer_UI
{

	protected $errors = null;
	protected $notices = [];

	public function __construct()
	{
		add_action('wp_ajax_dipi_layout_import', [$this, 'ajax_layout_import_action']);
		add_action('wp_ajax_dipi_layout_finalize', [$this, 'ajax_dipi_layout_finalize']);
		add_action('wp_ajax_dipi_setup_layout_ui', [$this, 'ajax_layout_setup_layout_ui']);
		add_action('wp_ajax_dipi_layout_setup', [$this, 'ajax_layout_setup_action']);
		$this->errors = new \WP_Error();
	}

	public function import_builder_templates()
	{
		require_once plugin_dir_path(__FILE__) . 'class-dipi-theme-builder-importer.php';
		$impoter = new DIPI_Theme_Builder_Importer($_POST['package_name']);
		return $impoter->import();
	}

	public function ajax_dipi_layout_finalize()
	{
		if (!isset($_POST['dipi_layout_import_nonce'])) {
			return;
		}
		if (!wp_verify_nonce($_POST['dipi_layout_import_nonce'], 'dipi_layout_import_nonce')) {
			return;
		}
		global $wp_filesystem;
		WP_Filesystem();
		$layouts_list = json_decode($wp_filesystem->get_contents(DIPI_LAYOUTS_LIST));
		$package = $layouts_list->{$_POST['layout_name']};
		update_option('dipi_active_layout', $_POST['layout_name']);
		$wp_filesystem->delete(DIPI_LAYOUT_PATH . $package->package_name, true, 'r');
		echo json_encode(['success' => true]);
		wp_die();
	}

	function ajax_layout_import_action()
	{

		if (!defined('WP_LOAD_IMPORTERS')) {
			define('WP_LOAD_IMPORTERS', true);
		}
		echo json_encode($this->import_action());
		wp_die();
	}

	public function initialize()
	{
		update_option('dipi_svg_upload', 'on');

		global $wp_filesystem;
		WP_Filesystem();
		require_once plugin_dir_path(__FILE__) . 'class-dipi-layout-importer.php';
		$dipi_importer = new Dipi_Layout_Importer('epanel');

		$results = ['success' => true];
		// Install wordpress importer if not exists.
		if (!$wp_filesystem->exists(WP_PLUGIN_DIR . '/wordpress-importer/wordpress-importer.php')) {
			$results = $dipi_importer->install_plugin('wordpress-importer');
		}
		if ($results['success']) {
			// Activate wordpress importer.
			$dipi_importer->activate_plugin('wordpress-importer/wordpress-importer.php');
		}
		return $results;
	}

	public function should_show_max_execution_time_warning()
	{
		//Get max exection time configured on server
		dipi_log("Wir haben ini_get", ini_get('max_execution_time'));
		dipi_log("Wir haben get_cfg_var", get_cfg_var('max_execution_time'));
		dipi_log("Wir haben is_writable", is_writable(ABSPATH . "wp-config.php"));
		dipi_log("Wir haben is_writable /", is_writable(ABSPATH . "/wp-config.php"));
		$target_max_execution_time = 300;
		return ini_get('max_execution_time') < $target_max_execution_time
			&& get_cfg_var('max_execution_time') < $target_max_execution_time
			&& !is_writable(ABSPATH . "wp-config.php")
			&& !is_writable(ABSPATH . "/wp-config.php");
	}

	public function import_action()
	{
		if (!isset($_POST['dipi_layout_import_nonce'])) {
			return;
		}
		if (!wp_verify_nonce($_POST['dipi_layout_import_nonce'], 'dipi_layout_import_nonce')) {
			return;
		}
		global $wp_filesystem;
		WP_Filesystem();
		require_once plugin_dir_path(__FILE__) . 'class-dipi-layout-importer.php';

		$dipi_importer = new Dipi_Layout_Importer('epanel');
		$task = $_POST['task'];
		$BASE_PATH = DIPI_LAYOUT_PATH . $_POST['package_name'] . '/import-files/';
		$results = [];
		switch ($task) {
			case 'initialize':
				$results['initialize'] = $this->initialize();
				break;
			case 'download':
				require_once plugin_dir_path(__FILE__) . 'class-dipi-zip-uploader.php';
				$layouts_list = json_decode($wp_filesystem->get_contents(DIPI_LAYOUTS_LIST));
				// downloady layout package
				$layout_info = $layouts_list->{$_POST['layout_name']};



				$response = $this->download_layout_package($layout_info);
				if ($response['success']) {
					$dipi_zip = new DIPI_ZIP_Uploader('divi-pixel-layouts');
					// Unzip package
					$base_name = $layout_info->package_name . '.zip';
					$layout_path = $dipi_zip->unzip_file(DIPI_LAYOUT_PATH . $base_name);
					$results['download'] = [
						'success' => true,
						'layout_path' => $layout_path
					];
				} else {
					$results['download'] = $response;
				}


				break;

			case 'content':
				// Import Content
				$content_file = $BASE_PATH . 'content.xml';
				$results['content'] = $dipi_importer->import_wp_content($content_file);
				break;
			case 'widgets':
				// Import WP widgets
				$widgets_file = $BASE_PATH . 'widgets.wie';
				$results['widgets'] = $dipi_importer->import_widgets($widgets_file);
				break;
			case 'customizer':
				// Import WP customizer
				$customizer_file = $BASE_PATH . 'customizer.dat';
				$results['customizer'] = $dipi_importer->import_customizer($customizer_file);
				break;
			case 'divi-options':
				// Import Divi Pixel Settings
				$divi_settings = $BASE_PATH . 'divi-theme-options.json';
				$results['divi-options'] = $dipi_importer->import_divi_settings($divi_settings);
				break;
			case 'dipi-options':
				// Import Divi Pixel Settings
				$dipi_settings = $BASE_PATH . 'divi-pixel-settings.json';
				$results['dipi-options'] = $dipi_importer->import_dipi_settings($dipi_settings);
				break;
			case 'builder-templates':
				// Import Divi Builder Templates
				$results['builder-templates'] = $this->import_builder_templates();
				break;
		}
		return $results;
	}

	public function download_layout_package($package)
	{
		$response = wp_remote_get($package->package_url, [
			'timeout' => 30,
			'sslverify' => false
		]);
		if (is_wp_error($response)) {
			return [
				'success' => false,
				'errorMessage' => "Faild to download layout package (invalid package url)",
				'res' => $response
			];
		}
		$content_type = wp_remote_retrieve_header($response, 'content-type');
		// echo json_encode(sys_get_temp_dir());die(); 
		if ($content_type === "application/zip") {
			$zip = $response['body'];
			$file = DIPI_LAYOUT_PATH . $package->package_name . '.zip';
			global $wp_filesystem;
			$wp_filesystem->put_contents($file, $zip);
			return [
				'success' => true
			];
		} else {
			return [
				'success' => false,
				'errorMessage' => "Failed to download layout package (invalid file type)"
			];
		}
	}

	public function download_file($url)
	{
		// Use basename() function to return the base name of file
		$file_name = basename($url);
		if (file_put_contents(DIPI_LAYOUT_PATH . $file_name, fopen($url, 'r'))) {
			return $file_name;
		} else {
			return false;
		}
	}

	public function layout_list()
	{
		global $wp_filesystem;
		WP_Filesystem();
		if (!$wp_filesystem->exists(DIPI_LAYOUTS_LIST)) {
			return;
		}
		if (!$wp_filesystem->exists(DIPI_LAYOUT_PATH)) {
			wp_mkdir_p(DIPI_LAYOUT_PATH);
		}

		$layouts_list = json_decode($wp_filesystem->get_contents(DIPI_LAYOUTS_LIST));
		ob_start();
		?>
		<div class="layout-card-list-container dipi-layout-importer-setp-1">
			<?php
			$active_layout = get_option('dipi_active_layout');

			foreach ($layouts_list as $layout_name => $layout) {
				$extra_class = '';
				if (isset($layout->tag) && $layout->tag === 'coming-soon'):
					$extra_class = 'coming-soon';
				endif;
				?>
				<div class="layout-card <?php echo esc_attr($extra_class) ?>">
					<div class="layout-importer-top-actions">
						<a href="<?php echo $layout->download_url ?>" target="blank" class="dipi-tippy"
							data-tooltip="Download layout package.">
							<img width="15px" height="15px"
								src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciICAgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJ0cmFuc3BhcmVudCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgY2xhc3M9ImZlYXRoZXIgZmVhdGhlci1kb3dubG9hZCI+PHBhdGggZD0iTTIxIDE1djRhMiAyIDAgMCAxLTIgMkg1YTIgMiAwIDAgMS0yLTJ2LTQiPjwvcGF0aD48cG9seWxpbmUgcG9pbnRzPSI3IDEwIDEyIDE1IDE3IDEwIj48L3BvbHlsaW5lPjxsaW5lIHgxPSIxMiIgeTE9IjE1IiB4Mj0iMTIiIHkyPSIzIj48L2xpbmU+PC9zdmc+" />
						</a>
						<a href="<?php echo $layout->details_url ?>" target="blank" class="dipi-tippy"
							data-tooltip="Layout Details.">
							<img width="15px" height="15px"
								src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciICAgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBjbGFzcz0iZmVhdGhlciBmZWF0aGVyLWxpbmsiPjxwYXRoIGQ9Ik0xMCAxM2E1IDUgMCAwIDAgNy41NC41NGwzLTNhNSA1IDAgMCAwLTcuMDctNy4wN2wtMS43MiAxLjcxIj48L3BhdGg+PHBhdGggZD0iTTE0IDExYTUgNSAwIDAgMC03LjU0LS41NGwtMyAzYTUgNSAwIDAgMCA3LjA3IDcuMDdsMS43MS0xLjcxIj48L3BhdGg+PC9zdmc+" />
						</a>
						<?php if (isset($layout->tag) && $layout->tag !== 'coming-soon'): ?>
							<div class="dipi-layout-ribbon"><?php echo $layout->tag ?></div>
						<?php endif; ?>
					</div>



					<?php if ($active_layout == $layout_name): ?>
						<div class="dipi-layout-active-ribbon">
							<img class="active-layout" src="<?php echo plugin_dir_url(__FILE__) . '/assets/check.png' ?>" />
						</div>
					<?php endif; ?>


					<h2><?php echo $layout->name ?> </h2>
					<?php if (isset($layout->tag) && $layout->tag === 'coming-soon'): ?>
						<p><?php echo $layout->description ?></p>
						<h3><?php echo esc_html__('Coming Soon', 'dipi-divi-pixel') ?></h3>
					<?php endif; ?>
					<?php if (!isset($layout->tag) || $layout->tag !== 'coming-soon'): ?>
						<p><?php echo $layout->description ?></p>
						<div class="dipi-layout-action-group">
							<a class="dipi-layout-btn-default dipi-layout-btn" href="<?php echo $layout->demo_url ?>"
								target="blank"><?php echo esc_html__('Demo', 'dipi-divi-pixel') ?></a>
							<form method="POST" action="">
								<button class="dipi-layout-select-layout dipi-layout-btn dipi-layout-btn-primary" class="submit button"
									type="submit"><?php echo esc_html__('Import', 'dipi-divi-pixel') ?></button>
								<input type="hidden" name="dipi-layout-name" value="<?php echo $layout_name ?>" />
							</form>
							<?php if ($active_layout == $layout_name): ?>
								<button id="dipi-layout-setup-layout-opener"
									class="dipi-layout-btn-primary dipi-layout-btn"><?php echo esc_html__('Setup Layout', 'dipi-divi-pixel') ?></button>
							<?php endif; ?>
						</div>
					<?php endif; ?>

					<img class="layout-thumb" src="<?php echo $layout->thumb ?>" />
				</div>
				<?php
			}
			?>
		</div>
		<?php
		return ob_get_clean();
	}


	public function layout_list_ui()
	{ ?>
		<?php wp_nonce_field('nonce', 'nonce'); ?>
		<div id="dipi-layout-list">
			<div id="dipi-layout-list-header">
				<div id="dipi_settings_page_header">
					<div id="dipi_logo">
						<span class="dp-divi-pixel-full"></span> <span
							class="divi-layouts-subtitle"><?php echo esc_html__('Layouts', 'dipi-divi-pixel') ?></span>
					</div>
				</div>

			</div>
			<?php echo $this->layout_list() ?>
			<?php $this->importer_config_ui() ?>
			<?php $this->results_ui() ?>

		</div>
		<?php
	}

	public function importer_config_ui()
	{
		?>
		<div id="dipi-layout-importer-config" class="dipi-layout-box dipi-layout-importer-setp-2">
			<div>


				<h3 style="margin-bottom:5px"><span class="dipi-import-layout-name"></span>
					<?php echo esc_html__('import content options', 'dipi-divi-pixel') ?></h3>
				<p style="margin-top:0px">Select assets you want to import.</p>


				<div>
					<form method="POST" action="">
						<?php wp_nonce_field('dipi_layout_import_nonce', 'dipi_layout_import_nonce'); ?>
						<label class="dipi-layout-checkbox" for="layout-content-wp-content">
							<input id="layout-content-wp-content" name="dipi_layout_conten" value="content" checked
								type="checkbox" /> Content
							<span class="dipi-layout-checkbox-box"></span>
						</label>
						<label class="dipi-layout-checkbox" for="layout-content-wp-widgets">
							<input id="layout-content-wp-widgets" name="dipi_layout_conten" value="widgets" checked
								type="checkbox" /> Widgets
							<span class="dipi-layout-checkbox-box"></span>
						</label>
						<label class="dipi-layout-checkbox" for="layout-content-wp-customizer">
							<input id="layout-content-wp-customizer" name="dipi_layout_conten" value="customizer" checked
								type="checkbox" /> Customizer Settings
							<span class="dipi-layout-checkbox-box"></span>
						</label>
						<label class="dipi-layout-checkbox" for="layout-content-divi-options">
							<input id="layout-content-divi-options" name="dipi_layout_conten" value="divi-options" checked
								type="checkbox" /> Divi Options
							<span class="dipi-layout-checkbox-box"></span>
						</label>
						<label class="dipi-layout-checkbox" for="layout-content-dipi-options">
							<input id="layout-content-dipi-options" name="dipi_layout_conten" value="dipi-options" checked
								type="checkbox" /> Divi Pixel Options
							<span class="dipi-layout-checkbox-box"></span>
						</label>
						<label class="dipi-layout-checkbox" for="layout-content-builder-templates">
							<input id="layout-content-builder-templates" name="dipi_layout_conten" value="builder-templates"
								checked type="checkbox" /> Theme Builder Templates
							<span class="dipi-layout-checkbox-box"></span>
						</label>

						<div style="margin-top:20px">
							<button class="dipi-layout-btn-default dipi-layout-btn dipi-layout-back" name=""
								type="submit"><?php echo esc_html__('Back') ?></button>
							<button id="dipi-layout-start-import" class="dipi-layout-btn dipi-layout-btn-primary" name="back"
								type="submit"><?php echo esc_html__('Start Importing') ?></button>
						</div>
					</form>
				</div>
			</div>
			<div class="sidebar">
				<h3>Server Requirements</h3>
				<p>There are specific minimum requirements regarding memory, upload file size, and execution time that
					must be satisfied to ensure seamless functionality. Without these prerequisites, the plugin's performance
					cannot be guaranteed, potentially leading to errors during import.</p>
				<ul class="requirments-list">
					<li>post_max_size (512M)</li>
					<li>upload_max_filesize (256M)</li>
					<li>memory_limit (256M)</li>
					<li>max_input_time (300)</li>
					<li>max_execution_time (300)</li>
				</ul>
				<p>Usually, you can configure these values in your php.ini or wp-config.php. 
				   If you are unsure, cannot access either of those files, or your changes don't take effect, contact your hosting provider.
				</p>
			</div>

		</div>
		<?php
	}

	public function results_ui()
	{
		?>
		<div id="dipi-layout-importer-results" class="dipi-layout-box dipi-layout-importer-setp-3">
			<div class="errors-list">
				<ul></ul>
			</div>
			<h2>Import result for layout: <em><span id="dipi-layout-layout-name"></span></em>
				<h2>
					<div class="dipi-layout-progress">
						<div id="dipi-layout-progress-value" class="dipi-layout-progress-value"></div>
					</div>
					<div id="dipi-import-log">

						<div class="dipi-layout-importer-task dipi-layout-importer-task-initialize">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span><?php echo esc_html__('Initializing', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-download">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span>
							<?php echo esc_html__('Downloading Layout Package', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-content">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span><?php echo esc_html__('Importing Content', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-widgets">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span>
							<?php echo esc_html__('Importing Widgets', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-customizer">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span>
							<?php echo esc_html__('Importing Customizer', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-divi-options">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" />
							</span>
							<?php echo esc_html__('Importing Divi Options', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-dipi-options">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" /></span>
							<?php echo esc_html__('Importing Divi Pixel Options', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-builder-templates">
							<span class="dipi-layout-progress-icon">
								<img src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" /></span>
							<?php echo esc_html__('Importing Theme Builder Templates', 'dipi-divi-pixel'); ?>
						</div>
						<div class="dipi-layout-importer-task dipi-layout-importer-task-done">
							<span class="dipi-layout-progress-icon"><img
									src="<?php echo plugin_dir_url(__FILE__) . '/assets/spinner.gif' ?>" /></span>
							<span class="message"><?php echo esc_html__('All Done! Enjoy.', 'dipi-divi-pixel'); ?></span>
						</div>
					</div>
		</div>
		<?php
	}

	private function get_wp_pages_list()
	{
		$all_pages = get_pages();
		$pages_list = [];
		if (!is_array($all_pages) && !is_object($all_pages))
			return $pages_list;
		foreach ($all_pages as $page) {
			if ($page->post_status == 'publish') {
				$pages_list[$page->ID] = (isset($page->post_title) && !empty($page->post_title)) ? $page->post_title : esc_html__('(no title)', 'dipi-divi-pixel');
			}
		}
		return $pages_list;
	}

	public function ajax_layout_setup_action()
	{
		$homepage = get_page_by_title('Front Page');
		$page_id = $_POST['homepage'];
		$menus = $_POST['menus'];
		$cta_menus = $_POST['cta_menus'];
		update_option('page_on_front', $page_id);
		update_option('show_on_front', 'page');
		update_option('dipi_menu_cta_menu', $cta_menus);
		foreach ($menus as $location => $value) {
			if ($value !== 'none') {
				$locations = get_theme_mod('nav_menu_locations');
				$locations[$location] = $value;
				set_theme_mod('nav_menu_locations', $locations);
			}
		}
		echo json_encode(['success' => true]);
		wp_die();
	}

	public function setup_layout_ui()
	{
		ob_start();
		?>
		<div id="dipi-layout-importer-setup" class="dipi-layout-box dipi-layout-importer-setp-4">
			<h2><?php echo esc_html__('Setup Layout Settings', 'dipi-divi-pixel'); ?></h2>
			<?php wp_nonce_field('dipi_layout_setup_nonce', 'dipi_layout_setup_nonce'); ?>
			<div class="dipi-layout-field-group">
				<label>
					<?php echo esc_html__('Select Homepage') ?>
				</label>
				<?php
				$front_page = get_option('page_on_front');
				?>
				<select name="dipi_layout_homepage">
					<?php foreach ($this->get_wp_pages_list() as $key => $value):
						$selected = ($front_page == $key) ? 'selected' : '';
						?>
						<option <?php echo $selected ?> value="<?php echo $key ?>"><?php echo $value ?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<?php
			$current_locations = get_theme_mod('nav_menu_locations');
			foreach (get_registered_nav_menus() as $location_slug => $location):
				?>
				<div class="dipi-layout-field-group">
					<label>
						<?php echo esc_html__('Select ') . $location ?>
					</label>
					<select name="<?php echo $location_slug; ?>" class="dipi-layout-menu">
						<option value="none"><?php echo esc_html__('None', 'dipi-divi-pixel') ?></option>
						<?php foreach (wp_get_nav_menus() as $menu):
							$selected = (isset($current_locations[$location_slug]) && $current_locations[$location_slug] == $menu->term_id) ? 'selected' : '';
							?>
							<option <?php echo $selected ?> value="<?php echo $menu->term_id ?>"><?php echo $menu->name ?></option>
						<?php endforeach; ?>
					</select>
				</div>
			<?php endforeach; ?>
			<div class="dipi-layout-field-group">
				<label>
					<?php echo esc_html__('Select Menu to display CTA') ?>
				</label>
				<div class="dipi-layout-checkbox-group">
					<?php
					$menus = get_option('dipi_menu_cta_menu');
					foreach (wp_get_nav_menus() as $menu):
						$checked = (is_array($menus) && in_array($menu->term_id, $menus)) ? 'checked' : '';
						?>
						<label for="menu_<?php echo $menu->term_id ?>">
							<input id="menu_<?php echo $menu->term_id ?>" type="checkbox" name="cta_menu[]"
								value="<?php echo $menu->term_id ?>" <?php echo $checked ?>> <?php echo $menu->name ?>
						</label>
					<?php endforeach; ?>
				</div>
			</div>
			<div class="dipi-layout-field-group">
				<button id="dipi-layout-setup-layout" class="dipi-layout-btn-ajax dipi-layout-btn dipi-layout-btn-primary"
					class="submit button" type="submit">
					<span class="normal"><?php echo esc_html__('Save', 'dipi-divi-pixel'); ?></span>
					<span class="done"><?php echo esc_html__('Done', 'dipi-divi-pixel'); ?></span>
					<span class="loading"><?php echo $this->loading_gif(); ?></span>
				</button>

				<button id="dipi-layout-setup-layout-back" class="dipi-layout-btn-ajax dipi-layout-btn dipi-layout-btn-default"
					class="submit button" type="submit">
					<?php echo esc_html__('Back to Layouts', 'dipi-divi-pixel'); ?>
				</button>
			</div>

		</div>
		<?php
		return ob_get_clean();
	}

	public function ajax_layout_setup_layout_ui()
	{
		echo json_encode([
			'success' => true,
			'content' => $this->setup_layout_ui()
		]);
		wp_die();
	}

	public function loading_gif()
	{
		ob_start();
		?>
		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
			style="margin: auto; background: none; display: block; shape-rendering: auto;" width="30px" height="30px"
			viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
			<circle cx="84" cy="50" r="10" fill="#ffffff">
				<animate attributeName="r" repeatCount="indefinite" dur="0.25s" calcMode="spline" keyTimes="0;1" values="10;0"
					keySplines="0 0.5 0.5 1" begin="0s"></animate>
				<animate attributeName="fill" repeatCount="indefinite" dur="1s" calcMode="discrete" keyTimes="0;0.25;0.5;0.75;1"
					values="#ffffff;#ffffff;#ffffff;#ffffff;#ffffff" begin="0s"></animate>
			</circle>
			<circle cx="16" cy="50" r="10" fill="#ffffff">
				<animate attributeName="r" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="0;0;10;10;10" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="0s"></animate>
				<animate attributeName="cx" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="16;16;16;50;84" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="0s"></animate>
			</circle>
			<circle cx="50" cy="50" r="10" fill="#ffffff">
				<animate attributeName="r" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="0;0;10;10;10" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.25s"></animate>
				<animate attributeName="cx" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="16;16;16;50;84" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.25s">
				</animate>
			</circle>
			<circle cx="84" cy="50" r="10" fill="#ffffff">
				<animate attributeName="r" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="0;0;10;10;10" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.5s"></animate>
				<animate attributeName="cx" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="16;16;16;50;84" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.5s">
				</animate>
			</circle>
			<circle cx="16" cy="50" r="10" fill="#ffffff">
				<animate attributeName="r" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="0;0;10;10;10" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.75s"></animate>
				<animate attributeName="cx" repeatCount="indefinite" dur="1s" calcMode="spline" keyTimes="0;0.25;0.5;0.75;1"
					values="16;16;16;50;84" keySplines="0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1;0 0.5 0.5 1" begin="-0.75s">
				</animate>
			</circle>
		</svg>
		<?php
		return ob_get_clean();
	}
}