<?php 
 
class DIPI_ZIP_Uploader {

    protected $folder = '';

    public function __construct( $folder ) {
        $this->folder = $folder;
    }

    /**
     * Get folder name where to upload
     *
     * @param $post_id
     *
     * @return string
     */
    public function get_folder_name( $filename ) {
        return sanitize_title( $filename );
    }

    /**
     * Get target path for the parent folder where all files are uploaded
     *
     * @return string
     */
    public function get_target_path() {
        $upload_directory = wp_get_upload_dir();
        $upload_baseurl   = $upload_directory['basedir'];
        return trailingslashit( $upload_baseurl ) . $this->folder;
    }

    /**
     * Get path
     *
     * @param $post_id
     *
     * @return string
     */
    public function get_folder_path( $folder ) {
        return trailingslashit( $this->get_target_path() ) . $folder;
    }

    /**
     * Check if there is an error
     *
     * @param $error
     *
     * @return bool|WP_Error
     */
    public function check_error($error) {
        $file_errors = array(
            0 => __( "There is no error, the file uploaded with success", 'dipi-divi-pixel' ),
            1 => __( "The uploaded file exceeds the upload_max_files in server settings", 'dipi-divi-pixel' ),
            2 => __( "The uploaded file exceeds the MAX_FILE_SIZE from html form", 'dipi-divi-pixel' ),
            3 => __( "The uploaded file uploaded only partially", 'dipi-divi-pixel' ),
            4 => __( "No file was uploaded", 'dipi-divi-pixel' ),
            6 => __( "Missing a temporary folder", 'dipi-divi-pixel' ),
            7 => __( "Failed to write file to disk", 'dipi-divi-pixel' ),
            8 => __( "A PHP extension stoped file to upload", 'dipi-divi-pixel' ),
        );

        if ( $error > 0 ) {
            return new \WP_Error( 'file-error', $file_errors[ $error ] );
        }

        return true;
    }

    public function upload( $file ) {
		/** @var $wp_filesystem \WP_Filesystem_Direct */
    global $wp_filesystem;
    
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			include_once 'wp-admin/includes/file.php';
		}
   
		WP_Filesystem();

		$file_error = $file["file"]["error"];

		// Check for Errors
		if ( is_wp_error( $this->check_error( $file_error ) ) ) {
			return $this->check_error( $file_error );
		}
    
		$file_name       = $file["file"]["name"];
		$file_name_arr   = explode( '.', $file_name );
		$extension       = array_pop( $file_name_arr );
		$filename        = implode( '.', $file_name_arr ); // File Name
		$zip_file        = sanitize_title( $filename ) . '.' . $extension; //Our File

		if ( 'zip' !== $extension ) {
			return new WP_Error( 'no-zip', 'This does not seem to be a ZIP file' );
		}

		$temp_name  = $file["file"]["tmp_name"];
		$file_size  = $file["file"]["size"];

    // Get our destination folder
		$current_folder = $this->get_folder_path( $this->get_folder_name( $filename ) );

		// Get default folder that contains all zips. Create if does not exists.
		$default_target = $this->get_target_path();
    // Create our default folder if it does not exist
		if( ! file_exists( $default_target ) ){
			mkdir( $default_target );
		}

		// Get folder path
		$upload_path = $this->get_folder_path( $this->get_folder_name( $filename ) );
    // We will overwrite it all, so remove it.
		if ( $wp_filesystem->exists( $upload_path ) ) {
			$wp_filesystem->delete( $upload_path, true );
		}
    
    // Create it
		if ( ! $wp_filesystem->exists( $upload_path ) ) {
			$wp_filesystem->mkdir( $upload_path );
		}

		// Folder name where we will upload the ZIP
		$working_dir = $upload_path . '-zip';
    
    // Delete if such folder exists
		if ( $wp_filesystem->is_dir( $working_dir ) ) {
			$wp_filesystem->delete( $working_dir, true );
		}
    // Create the folder to hold our zip file
		$wp_filesystem->mkdir( $working_dir );
		
    // Uploading ZIP file
		if( move_uploaded_file( $temp_name, $working_dir . "/" . $zip_file ) ){

			// Unzip the file to the upload path
			$unzip_result = unzip_file( $working_dir . "/" . $zip_file, $upload_path );

			if ( is_wp_error( $unzip_result ) ) {
				return $unzip_result;
			} else {
				// No errors with unzips, let's delete everything and unzip it again.
				if ( $wp_filesystem->is_dir( $upload_path ) ) {
					$wp_filesystem->delete( $upload_path, true );
				}
				$wp_filesystem->mkdir( $upload_path );
				unzip_file( $working_dir . "/" . $zip_file, $upload_path );
			}

			// Remove the uploaded zip
			@unlink( $working_dir . "/" . $zip_file );
			if ( $wp_filesystem->is_dir( $working_dir ) ) {
				$wp_filesystem->delete( $working_dir, true );
			}

			return  $upload_path;
		} else {
			return new \WP_Error( 'not-uploaded', __( 'Could not upload file', 'dipi-divi-pixel' ) );
		}
	}
  public function unzip_file($file) {

    global $wp_filesystem;
    
 
   
		WP_Filesystem();

    $base_name = basename($file, '.zip');
    $unzip_path = DIPI_LAYOUT_PATH . $base_name;
    $unzip_result = unzip_file( $file, DIPI_LAYOUT_PATH  );
    if ( is_wp_error( $unzip_result ) ) {
      echo json_encode($unzip_result);
      return $unzip_result;
    } else {
      // No errors with unzips, let's delete everything and unzip it again.
      if ( $wp_filesystem->is_dir( $unzip_path ) ) {
        $wp_filesystem->delete( $unzip_path, true );
      }
      // $wp_filesystem->mkdir( $unzip_path );
      unzip_file( $file, DIPI_LAYOUT_PATH );
    }

    // Remove the uploaded zip
    @unlink( $file );
    

    return  $unzip_path;
  }

}