<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.divi-pixel.com/
 * @since             1.0.0
 * @package           Dipi_Layout_Importer
 *
 * @wordpress-plugin
 * Plugin Name:       Divi Pixel Layout Importer 
 * Plugin URI:        https://www.divi-pixel.com/
 * Description:       The Divi Pixel Layout Importer lets you import full website templates in just a few clicks.
 * Version:           1.0.0
 * Author:            Octolab OÜ
 * Author URI:        https://www.divi-pixel.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dipi-layout-importer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'DIPI_LAYOUT_IMPORTER_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-dipi-layout-importer-activator.php
 */
function activate_dipi_layout_importer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dipi-layout-importer-activator.php';
	Dipi_Layout_Importer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-dipi-layout-importer-deactivator.php
 */
function deactivate_dipi_layout_importer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dipi-layout-importer-deactivator.php';
	Dipi_Layout_Importer_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_dipi_layout_importer' );
register_deactivation_hook( __FILE__, 'deactivate_dipi_layout_importer' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-dipi-layout-importer.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_dipi_layout_importer() {

	$plugin = new Dipi_Layout_Importer_Plugin();
	$plugin->run();

}
run_dipi_layout_importer();
