<?php

/**
 * Fired during plugin activation
 *
 * @link       https://www.divi-pixel.com/
 * @since      1.0.0
 *
 * @package    Dipi_Layout_Importer
 * @subpackage Dipi_Layout_Importer/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Dipi_Layout_Importer
 * @subpackage Dipi_Layout_Importer/includes
 * @author     Octolab OÜ 
 */
class Dipi_Layout_Importer_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{
		// We just try to set it always anyways and silently fail if files are not writeable
		if (file_exists(ABSPATH . "wp-config.php") && is_writable(ABSPATH . "wp-config.php")) {
			Dipi_Layout_Importer_Activator::wp_config_put();
		} else if (file_exists(dirname(ABSPATH) . "/wp-config.php") && is_writable(dirname(ABSPATH) . "/wp-config.php")) {
			Dipi_Layout_Importer_Activator::wp_config_put('/');
		}
	}

	private static function wp_config_put($slash = '')
	{
		$config = file_get_contents(ABSPATH . "wp-config.php");
		$config = preg_replace("/^([\r\n\t ]*)(\<\?)(php)?/i", "<?php set_time_limit(600);//divi-pixel-layout-importer", $config);
		file_put_contents(ABSPATH . $slash . "wp-config.php", $config);
	}
}

