<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://www.divi-pixel.com/
 * @since      1.0.0
 *
 * @package    Dipi_Layout_Importer
 * @subpackage Dipi_Layout_Importer/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Dipi_Layout_Importer
 * @subpackage Dipi_Layout_Importer/includes
 * @author     Octolab OÜ 
 */
class Dipi_Layout_Importer_Deactivator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate()
	{
		// We just try to unset it always and silently fail if files are not writeable
		if (file_exists(ABSPATH . "wp-config.php") && is_writable(ABSPATH . "wp-config.php")) {
			Dipi_Layout_Importer_Deactivator::wp_config_delete();
		} else if (file_exists(dirname(ABSPATH) . "/wp-config.php") && is_writable(dirname(ABSPATH) . "/wp-config.php")) {
			Dipi_Layout_Importer_Deactivator::wp_config_delete('/');
		}
	}



	private static function wp_config_delete($slash = '')
	{
		$config = file_get_contents(ABSPATH . "wp-config.php");
		$config = preg_replace("/( ?)(set_time_limit)( ?)(\()( ?)600( ?)(\))( ?);( ?)\/\/divi-pixel-layout-importer/i", "", $config);
		file_put_contents(ABSPATH . $slash . "wp-config.php", $config);
	}
}
