<?php
namespace DIPI\Modules\HoverGalleryItem\HoverGalleryItemTraits;

if ( ! defined( 'ABSPATH' ) ) {
    die( 'Direct access forbidden.' );
}

use ET\Builder\Framework\Utility\HTMLUtility;
use ET\Builder\Packages\IconLibrary\IconFont\Utils;
use ET\Builder\FrontEnd\BlockParser\BlockParserStore;
use ET\Builder\Packages\Module\Options\Element\ElementComponents;
use ET\Builder\Packages\Module\Module;
use DIPI\Modules\BaseTraits\PopupGalleryTrait;

trait RenderCallbackTrait {
  
  use PopupGalleryTrait;

  public static function render_callback( $attrs, $content, $block, $elements ) {
 
    $use_button = $attrs['button']['innerContent']['desktop']['value']['useButton'] ?? 'off';
    
    $children_ids = $block->parsed_block['innerBlocks'] ? array_map(
			function( $inner_block ) {
				return $inner_block['id'];
			},
			$block->parsed_block['innerBlocks']
		) : [];

 
    $content = ElementComponents::component(
      [
        'attrs'         => $attrs['module']['decoration'] ?? [],
        'id'            => $block->parsed_block['id'],

        // FE only.
        'orderIndex'    => $block->parsed_block['orderIndex'],
        'storeInstance' => $block->parsed_block['storeInstance'],
      ]
    ) . $content;

    $imageIcon = $attrs['imageIcon']['innerContent']['desktop']['value'];

    if('on' === $imageIcon['useIcon']) {
      $content .= sprintf(
        '<div class="dipi-content-image-icon-wrap dipi-icon-wrap">
          <span class="et-pb-icon et-pb-font-icon dipi-hover-box-content-icon">%1$s</span>
        </div>',
        Utils::process_font_icon($imageIcon['icon'])
      );
    } else {
      if(!empty($imageIcon['src'])){
        $content .= sprintf(
          '<div class="dipi-content-image-icon-wrap dipi-image-wrap">
            <img src="%1$s" class="dipi-hover-box-content-image" alt="%2$s" />
          </div>',
          $imageIcon['src'],
          $imageIcon['alt']
        );  
      }
  }
    $content .= $elements->render([
      'attrName'      => 'title'
    ]);
    $content .= $elements->render([
      'attrName'      => 'content'
    ]);

    if($use_button === 'on') {
      $content .= $elements->render([
        'attrName'      => 'button'
      ]);
    }

    return Module::render(
      [
        // FE only.
        'orderIndex'          => $block->parsed_block['orderIndex'],
        'storeInstance'       => $block->parsed_block['storeInstance'],

        // VB equivalent.
        'attrs'               => $attrs,
        'elements'            => $elements,
        'id'                  => $block->parsed_block['id'],
        'htmlAttrs' => [
          'test' => 'test',
          'data-item' => $block->parsed_block['id']
        ],
        'moduleclass'     => '',
        'name'                => $block->block_type->name,
        'classsFunction'  => [ ModuleclasssTrait::class, 'module_classs' ],
        'moduleCategory'      => $block->block_type->category,
        'classnamesFunction'  => [ ModuleClassnamesTrait::class, 'module_classnames' ],
        'stylesComponent'     => [ ModuleStylesTrait::class, 'module_styles' ],
        'scriptDataComponent' => [ ModuleScriptDataTrait::class, 'module_script_data' ],
        'parentAttrs'         => $parent->attrs ?? [],
        'parentId'            => $parent->id ?? '',
        'parentName'          => $parent->blockName ?? '',
        'children'            => $content,
				'childrenIds'         => $children_ids
      ]
    );
  }
}