<?php


/**
 * TODO: 
 * -If using graph API + Lightbox Gallery we could have settings to display the lightbox similarly to how it looks on instagram with comments at the side.
 *  but in the first step, it would surely be sufficient to have the caption and likes below the image and not worry about comments 
 * -option_category on each setting
 * -Option to display a little icon to indicate whether the image is a gallery or a video in itself
 * -Implement Load More button
 * 
 * 
 * 
 */

class DIPI_InstagramGrid extends DIPI_Builder_Module
{
    public $slug = 'dipi_instagram_grid';
    public $vb_support = 'on';

    protected $module_credits = array(
        'module_uri' => 'https://divi-pixel.com/modules/instagram',
        'author' => 'Divi Pixel',
        'author_uri' => 'https://divi-pixel.com',
    );

    public function init()
    {
        $this->name = esc_html__('Pixel Instagram Grid', 'dipi-divi-pixel');
        $this->icon_path = plugin_dir_path(__FILE__) . 'icon.svg';

        $instagram_accounts = \DiviPixel\DIPI_Settings::get_option('instagram_accounts');
        if (!empty($instagram_accounts)) {
            $this->instagram_accounts_basic = [
                'no_account' => esc_html__('-- Select Account --', 'dipi-divi-pixel'),
            ];
            foreach ($instagram_accounts as $account_id => $account) {
                $this->instagram_accounts_basic[$account_id] = $account['username'];
            }
        }

        $facebook_accounts = \DiviPixel\DIPI_Settings::get_option('facebook_accounts');
        if (!empty($facebook_accounts)) {
            $this->instagram_accounts_graph = [
                'no_account' => esc_html__('-- Select Account --', 'dipi-divi-pixel'),
            ];
            foreach ($facebook_accounts as $fb_account_id => $fb_account) {
                foreach ($fb_account['instagram_accounts'] as $insta_account_id => $insta_account) {
                    $this->instagram_accounts_graph["{$fb_account_id}_{$insta_account_id}"] = "{$insta_account['username']} ({$fb_account['name']})";
                }
            }
        }
    }

    public function get_settings_modal_toggles()
    {
        return [
            'general' => [
                'toggles' => [
                    'instagram' => esc_html__('Instagram', 'dipi-divi-pixel'),
                    // 'layout' => esc_html__('Layout', 'dipi-divi-pixel'),
                ],
            ],
            'advanced' => [
                'toggles' => [
                    'layout' => esc_html__('Layout', 'dipi-divi-pixel'),
                    'overlay' => esc_html__('Overlay', 'dipi-divi-pixel'),
                ],
            ],
        ];
    }

    public function get_fields()
    {
        $fields = [];
        $fields = array_merge($fields, $this->get_instagram_fields());
        $fields = array_merge($fields, $this->get_design_layout_fields());
        // $fields = array_merge($fields, $this->get_design_overlay_fields());
        return $fields;
    }

    private function get_instagram_fields()
    {
        $fields = [];

        $fields['instagram_api'] = [
            'label' => esc_html__('Instagram API', 'dipi-divi-pixel'),
            'description' => esc_html__('Select the type of Instagram API you want to use.', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'basic_option',
            'options' => [
                'basic' => esc_html__('Basic', 'dipi-divi-pixel'),
                'graph' => esc_html__('Graph', 'dipi-divi-pixel'),
            ],
            'default' => 'basic',
            'toggle_slug' => 'instagram',
        ];

        if (!empty($this->instagram_accounts_basic)) {
            $fields['instagram_account_basic'] = [
                'label' => esc_html__('Instagram Account', 'dipi-divi-pixel'),
                'description' => esc_html__('Select the Instagram account you want to use.', 'dipi-divi-pixel'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'options' => $this->instagram_accounts_basic,
                'default' => 'no_account',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'basic',
                ],
            ];
        } else {
            $fields['no_instagram_account_basic'] = [
                'label' => '',
                'type' => 'warning',
                'value' => true,
                'display_if' => true,
                'message' => sprintf(
                    esc_html__('No Instagram accounts connected via the Basic API. Please connect an account via the <a href="%s" target="_blank">Divi Pixel settings page</a>.', 'dipi-divi-pixel'),
                    \DiviPixel\DIPI_Settings::admin_url('settings', 'third_party_providers', 'settings_instagram_api_basic')
                ),
                'option_category' => 'basic_option',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'basic',
                ],
            ];
        }

        if (!empty($this->instagram_accounts_graph)) {
            $fields['instagram_account_graph'] = [
                'label' => esc_html__('Instagram Account', 'dipi-divi-pixel'),
                'description' => esc_html__('Select the Instagram account you want to use.', 'dipi-divi-pixel'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'options' => $this->instagram_accounts_graph,
                'default' => 'no_account',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'graph',
                ],
            ];
        } else {
            $fields['no_instagram_account_graph'] = [
                'label' => '',
                'type' => 'warning',
                'value' => true,
                'display_if' => true,
                'message' => sprintf(
                    esc_html__('No Instagram accounts connected via the Graph API. Please connect an account via the <a href="%s" target="_blank">Divi Pixel settings page</a>.', 'dipi-divi-pixel'),
                    \DiviPixel\DIPI_Settings::admin_url('settings', 'third_party_providers', 'settings_instagram_api_graph')
                ),
                'option_category' => 'basic_option',
                'toggle_slug' => 'instagram',
                'show_if' => [
                    'instagram_api' => 'graph',
                ],
            ];
        }

        //TODO: We can initially load N images to display in the VB but on frontend we should always load images asynchronously to prevent long page loading times or maybe if we have cached images and the cache is valid then we could show them directly :thinking:
        $fields['__images'] = [
            'type' => 'computed',
            'computed_callback' => ['DIPI_InstagramGrid', 'render_images'],
            'computed_depends_on' => [
                'instagram_api',
                'instagram_account_basic',
                'instagram_account_graph',
                'images_count',
                'layout',
            ],
            'computed_minimum' => [
                'instagram_api',
                'images_count',
            ],
        ];

        return $fields;
    }

    private function get_design_layout_fields(){
        $fields = [];
               
        $fields['layout'] = [
            'label' => esc_html__('Layout', 'dipi-divi-pixel'),
            'description' => esc_html__('Choose how the grid mode you would like to use.', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'layout',
            'default' => 'grid',
            'options' => array(
                'grid' => esc_html__('Grid', 'dipi-divi-pixel'),
                'masonry' => esc_html__('Masonry', 'dipi-divi-pixel'),
            ),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        $fields['open_images_in'] = [
            'label' => esc_html__('Open Images In', 'dipi-divi-pixel'),
            'description' => esc_html__('Choose what happens when you click on one of the images in the grid.', 'dipi-divi-pixel'),
            'type' => 'select',
            'option_category' => 'configuration',
            'default' => 'instagram',
            'options' => array(
                'instagram' => esc_html__('Instagram Website', 'dipi-divi-pixel'),
                'lightbox' => esc_html__('Lightbox Gallery', 'dipi-divi-pixel'),
            ),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        $fields['images_count'] = [
            'label' => esc_html__('Images Count', 'dipi-divi-pixel'),
            'description' => esc_html__('Choose how many images you want to initially display in the grid. In Grid mode, it is best to use a number which is dividable by the number of columns of all devices. For example, if you show 4 columns on desktops, 3 on tables and 2 on phones, you should use 12 here since 12 is dividable by 4, 3 and 2.', 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '9',
            'range_settings' => array(
                'min' => '1',
                'max' => '100',
                'step' => '1',
            ),
            'unitless' => true,
            'option_category' => 'layout',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        $fields['column_count'] = [
            'label' => esc_html__('Column Count', 'dipi-divi-pixel'),
            'description' => esc_html__("The number of colums to show on different device types, e. g. 4 on desktop, 3 on tablets and 2 on phones.", 'dipi-divi-pixel'),
            'type' => 'range',
            'default' => '3',
            'range_settings' => array(
                'min' => '1',
                'max' => '10',
                'step' => '1',
            ),
            'unitless' => true,
            'mobile_options' => true,
            'option_category' => 'layout',
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        $fields['column_gap'] = [
            'label' => esc_html__('Columns Gap', 'dipi-divi-pixel'),
            'description' => esc_html__("The spacing between each column.", 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'layout',
            'default' => '10px',
            'mobile_options' => true,
            'range_settings' => array(
                'min' => '0',
                'max' => '100',
                'step' => '1',
            ),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        $fields['row_gap'] = [
            'label' => esc_html__('Rows Gap', 'dipi-divi-pixel'),
            'description' => esc_html__("The spacing between images in the same column.", 'dipi-divi-pixel'),
            'type' => 'range',
            'option_category' => 'layout',
            'default' => '10px',
            'mobile_options' => true,
            'range_settings' => array(
                'min' => '0',
                'max' => '100',
                'step' => '1',
            ),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'layout',
        ];

        // $fields['enable_load_more'] = [
        //     'label' => esc_html__('Enable Load More Button', 'dipi-divi-pixel'),
        //     'type' => 'yes_no_button',
        //     'default' => 'off',
        //     'options' => [
        //         'off' => esc_html__('No', 'dipi-divi-pixel'),
        //         'on' => esc_html__('Yes', 'dipi-divi-pixel'),
        //     ],
        //     'tab_slug' => 'advanced',
        //     'toggle_slug' => 'layout',
        // ];

        return $fields;
    }

    static function render_images($args = array(), $conditional_tags = array(), $current_page = array())
    {
        $defaults = [
            'instagram_api' => 'basic',
            'instagram_account_basic' => 'no_account',
            'instagram_account_graph' => 'no_account',
            'images_count' => '9',
            'layout' => 'grid',
        ];

        $args = wp_parse_args($args, $defaults);

        if ($args['instagram_api'] === 'basic' && $args['instagram_account_basic'] === 'no_account') {
            return sprintf('<div>%1$s</div>', esc_html__('No account selected.', 'dipi-divi-pixel'));
        } else if ($args['instagram_api'] === 'graph' && $args['instagram_account_graph'] === 'no_account') {
            return sprintf('<div>%1$s</div>', esc_html__('No account selected.', 'dipi-divi-pixel'));
        }
        
        //Load media based on selected API
        try {
            if ($args['instagram_api'] === 'basic') {
                $media = self::get_media_basic($args['instagram_account_basic'], $args['images_count']);
            } else if ($args['instagram_api'] === 'graph') {
                $media = self::get_media_graph($args['instagram_account_graph'], $args['images_count']);
            } else {
                return sprintf('<div>%1$s</div>', esc_html__('Unknown Instagram API selected. Please choose either Basic or Graph.', 'dipi-divi-pixel'));
            }
        } catch (Exception $e){
            return $e->getMessage();
        }
        
        dipi_log("Wir haben ein paar Medien", $media);

        $items = $args['layout'] === 'masonry' ? [
            '<div class="grid-sizer"></div>',
            '<div class="gutter-sizer"></div>',
        ] : [];
                
        // Medium in Basic API
        // (
        //     [media_id] => 17918084104051673
        //     [account_id] => 4038588126261921
        //     [timestamp] => 2018-01-13 14:17:03
        //     [caption] => At the moment we are staying next to Mount #agung the active #vulcano on Bali. Yesterday he spit some smoke again but we are outside the danger zone 👌🌬
        //     [media_type] => IMAGE
        //     [permalink] => https://www.instagram.com/p/Bd5Ibkan0fl/
        //     [parent_id] => 
        //     [media_url] => https://scontent-dus1-1.cdninstagram.com/v/t51.2885-15/26335015_171313206814853_2524409780328464384_n.jpg?_nc_cat=109&ccb=1-5&_nc_sid=8ae9d6&_nc_ohc=1Yi21cMoGMEAX-gQvDH&_nc_ht=scontent-dus1-1.cdninstagram.com&edm=ANo9K5cEAAAA&oh=373c1303dced92489a75418fafbf80dd&oe=61331ECB
        //     [children_count] => 0
        // )
        foreach ($media as $medium) {
            $items[] = sprintf(
                '<div class="dipi_instagram_grid_item">
                    <div class="dipi_instagram_grid_item_img_container" href="%1$s">
                        <img src="%1$s" alt="%2$s"/>
                    </div> 
                </div>',
                $medium['media_url'],
                $medium['caption']
            );
        }
        
        return implode("", $items);       
    }

    static function get_media_basic($account_id, $images_count){
        $instagram_account = \DiviPixel\DIPI_Instagram_Basic_API::instance()->get_instagram_account($account_id);
        if(!$instagram_account){
            $message = sprintf('<div>%1$s</div>', esc_html__('The selected Instagram account is not connected. Please connect it in the Divi Pixel settings.', 'dipi-divi-pixel'));
            throw new Exception($message);
        }
        
        
        $media = \DiviPixel\DIPI_Instagram_Basic_API::instance()->get_media($account_id, $images_count);
        if(!$media){
            $message = sprintf(
                '<div>%1$s</div>', 
                sprintf(esc_html__('No images found for account %s.', 'dipi-divi-pixel'), $instagram_account['username'])
            );
            throw new Exception($message);
        }

        return $media;
    }

    static function get_media_graph($account_id, $images_count){
        $components = explode('_', $account_id);
        $facebook_account_id = $components[0];
        $instagram_account_id =  $components[1];
        
        $instagram_account = \DiviPixel\DIPI_Instagram_Graph_API::instance()->get_instagram_account($instagram_account_id);
        if (!$instagram_account) {
            $message = sprintf('<div>%1$s</div>', esc_html__('The selected Instagram account is not connected. Please connect it in the Divi Pixel settings.', 'dipi-divi-pixel'));
            throw new Exception($message);
        }

        $media = \DiviPixel\DIPI_Instagram_Graph_API::instance()->get_media($instagram_account_id, $images_count);
        if(!$media){
            $message = sprintf(
                '<div>%1$s</div>', 
                sprintf(esc_html__('No images found for account %s.', 'dipi-divi-pixel'), $instagram_account['username'])
            );
            throw new Exception($message);
        }

        return $media;
    }


    public function render($attrs, $content, $render_slug)
    {
        wp_enqueue_script('dipi_instagram_grid_public');

        $this->dipi_apply_css($render_slug);

        $classNames = [];
        if($this->props['layout'] === 'grid'){
            $classNames[] = 'dipi_instagram_grid_grid';
        } else if($this->props['layout'] === 'masonry'){
            $classNames[] = 'dipi_instagram_grid_masonry';            
        }

        return sprintf(
            '<div class="%2$s">
                %1$s
            </div>',
            self::render_images($this->props),
            implode(' ', $classNames)
        );
    }

    private function dipi_apply_css($render_slug){
        $this->dipi_apply_grid_css($render_slug);
        $this->dipi_apply_masonry_css($render_slug);
    }
    private function dipi_apply_grid_css($render_slug){
        if($this->props['layout'] !== 'grid'){
            return;
        }

        $column_count = $this->dipi_get_responsive_prop('column_count');
        $column_gap = $this->dipi_get_responsive_prop('column_gap');
        $row_gap = $this->dipi_get_responsive_prop('row_gap');

        //Width of grid items
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_grid',
            'declaration' => "display: grid; grid-template-columns: repeat({$column_count['desktop']}, 1fr); grid-column-gap: {$column_gap['desktop']}; grid-row-gap: {$row_gap['desktop']};",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_grid',
            'declaration' => "display: grid; grid-template-columns: repeat({$column_count['tablet']}, 1fr); grid-column-gap: {$column_gap['tablet']}; grid-row-gap: {$row_gap['tablet']};",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_grid',
            'declaration' => "display: grid; grid-template-columns: repeat({$column_count['phone']}, 1fr); grid-column-gap: {$column_gap['phone']}; grid-row-gap: {$row_gap['phone']};",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);
        
        



        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_item',
            'declaration' => "display: flex; position: relative;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_item:after',
            'declaration' => "content: ''; padding-bottom: 100%;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_item_img_container',
            'declaration' => "position: absolute; height: 100%; width: 100%;",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_item_img_container img',
            'declaration' => "object-fit: cover; height: 100%; width: 100%;",
        ]);
    }
    private function dipi_apply_masonry_css($render_slug){
        if($this->props['layout'] !== 'masonry'){
            return;
        }

        $column_count = $this->dipi_get_responsive_prop('column_count');
        $column_gap = $this->dipi_get_responsive_prop('column_gap');
        $row_gap = $this->dipi_get_responsive_prop('row_gap');

        //Width of grid items
        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .dipi_instagram_grid_item',
            'declaration' => "width: calc((100% - ({$column_count['desktop']} - 1) * {$column_gap['desktop']}) / {$column_count['desktop']});",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .dipi_instagram_grid_item',
            'declaration' => "width: calc((100% - ({$column_count['tablet']} - 1) * {$column_gap['tablet']}) / {$column_count['tablet']});",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_980'),
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .grid-sizer, %%order_class%% .dipi_instagram_grid_item',
            'declaration' => "width: calc((100% - ({$column_count['phone']} - 1) * {$column_gap['phone']}) / {$column_count['phone']});",
            'media_query' => \ET_Builder_Element::get_media_query('max_width_767'),
        ]);
        
        et_pb_responsive_options()->generate_responsive_css(
            $column_gap, 
            '%%order_class%% .gutter-sizer', 
            'width', 
            $render_slug
        );
        
        et_pb_responsive_options()->generate_responsive_css(
            $row_gap, 
            '%%order_class%% .dipi_instagram_grid_item', 
            'margin-bottom', 
            $render_slug
        );

        ET_Builder_Element::set_style($render_slug, [
            'selector' => '%%order_class%% .dipi_instagram_grid_item_img_container img',
            'declaration' => "display: block;",
        ]);
    }
}

new DIPI_InstagramGrid();
